/***********************************************************************/
/*  This file is part of the ARM Toolchain package                     */
/*  Copyright KEIL ELEKTRONIK GmbH 2011                                */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.c:  Device Description for ES32F0xx Flash             */
/*                                                                     */
/***********************************************************************/

#include "FlashOS.H"        /* FlashOS Structures, do not modify! */
#include "FlashParams.h"    /* flash parameters specification */

#ifdef FLASH_MEM
struct FlashDevice const FlashDevice  =  {
    FLASH_DRV_VERS,                     /* Driver Version, do not modify! */
    "ES32 External Flash W29N01HV",     /* Device Name */
    EXT8BIT,                            /* Device Type */
    FLASH_BASE_ADDR,                    /* Device Start Address, adjecnt with MCU SRAM address */
    FLASH_SIZE,                         /* Device Size in Bytes (128M) */
    FLASH_PAGE_SIZE,                    /* Programming Page Size, in byte: ignore spare area 64 bytes */
    0,                                  /* Reserved, must be 0 */
    0xFF,                               /* Initial Content of Erased Memory */
    7000,                               /* Program Page Timeout 1000 mSec */
    6000,                               /* Erase Sector Timeout 6000 mSec */
    {
        FLASH_SECTORE_SIZE, 0x00000000, /* Sector size and start offset of this sector group */
        SECTOR_END
    }
};
#endif

